/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.client.gui;

import buildcraft.core.BCCoreItems;
import buildcraft.energy.container.ContainerEngineRF;
import buildcraft.energy.tile.TileEngineRF;
import buildcraft.lib.BCLibConfig;
import buildcraft.lib.engine.IEngineLikeForLedger;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.GuiElementSimple;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.help.DummyHelpElement;
import buildcraft.lib.gui.help.ElementHelpInfo;
import buildcraft.lib.gui.ledger.LedgerEngine;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.misc.LocaleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiEngineRF
extends GuiBC8<ContainerEngineRF> {
    private static final ResourceLocation TEXTURE_BASE = new ResourceLocation("buildcraftenergy:textures/gui/rf_engine_gui.png");
    private static final int SIZE_X = 176;
    private static final int SIZE_Y = 177;
    private static final GuiIcon ICON_GUI = new GuiIcon(TEXTURE_BASE, 0.0, 0.0, 176.0, 177.0);
    private static final GuiIcon ICON_RF = new GuiIcon(TEXTURE_BASE, 176.0, 0.0, 16.0, 60.0);
    private static final GuiIcon ICON_OVERLAY = new GuiIcon(TEXTURE_BASE, 57.0, 18.0, 80.0, 23.0);
    private static final GuiRectangle RECT_UPGRADES = new GuiRectangle(60.0, 42.0, 74.0, 20.0);
    private static final GuiRectangle RECT_UPGRADE_TYPES = new GuiRectangle(60.0, 20.0, 74.0, 20.0);
    private static final GuiRectangle RECT_RF_BATTERY = new GuiRectangle(30.0, 17.0, 8.0, 62.0);

    public GuiEngineRF(final ContainerEngineRF container) {
        super(container);
        this.field_146999_f = 176;
        this.field_147000_g = 177;
        this.mainGui.shownElements.add(new LedgerEngine(this.mainGui, (IEngineLikeForLedger)((Object)container.tile), true));
        this.mainGui.shownElements.add(new DummyHelpElement(RECT_UPGRADES.offset(this.mainGui.rootElement), new ElementHelpInfo("buildcraft.help.rf_engine.upgrades.title", -1, "buildcraft.help.rf_engine.upgrades.desc")));
        this.mainGui.shownElements.add(new GuiElementSimple(this.mainGui, RECT_UPGRADE_TYPES.offset(this.mainGui.rootElement)){

            @Override
            public void addToolTips(List<ToolTip> tooltips) {
                if (this.contains(GuiEngineRF.this.mainGui.mouse)) {
                    ArrayList<String> lines = new ArrayList<String>();
                    lines.add(LocaleUtil.localize("buildcraft.gui.rf_engine.upgrade_types"));
                    for (Map.Entry<Item, Long> entry : TileEngineRF.RF_UPGRADE.entrySet()) {
                        String itemName = entry.getKey().func_77653_i(new ItemStack(entry.getKey()));
                        lines.add(itemName + " = +" + LocaleUtil.localizeMjFlow(entry.getValue()));
                    }
                    tooltips.add(new ToolTip(lines));
                }
            }
        });
        this.mainGui.shownElements.add(new GuiElementSimple(this.mainGui, RECT_RF_BATTERY.offset(this.mainGui.rootElement)){

            @Override
            public void addHelpElements(List<ElementHelpInfo.HelpPosition> elements) {
                long mjFlow = ((TileEngineRF)container.tile).getMjPerTick();
                int rfFlow = (int)(mjFlow / BCLibConfig.mjRfConversion.mjPerRf);
                String rf = LocaleUtil.localizeRf(rfFlow);
                String mj = LocaleUtil.localizeMjFlow(mjFlow);
                String conversion = LocaleUtil.localize("buildcraft.help.rf_engine.rf_battery.desc", rf, mj);
                ElementHelpInfo help = ElementHelpInfo.preTranslated("buildcraft.help.rf_engine.rf_battery.title", -1, conversion);
                elements.add(help.target(this));
            }

            @Override
            public void addToolTips(List<ToolTip> tooltips) {
                if (this.contains(GuiEngineRF.this.mainGui.mouse)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(LocaleUtil.formatRf(((TileEngineRF)container.tile).getCurrentRF()));
                    sb.append(" / ");
                    sb.append(LocaleUtil.localizeRf(10000));
                    tooltips.add(new ToolTip(sb.toString()));
                }
            }
        });
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks) {
        ICON_GUI.drawAt(this.mainGui.rootElement);
        double rfHeight = 60.0 * (double)((TileEngineRF)((ContainerEngineRF)this.container).tile).getCurrentRF() / 10000.0;
        double scale = new ScaledResolution(this.field_146297_k).func_78325_e();
        rfHeight = (double)Math.round(rfHeight * scale) / scale;
        ICON_RF.drawCutInside(new GuiRectangle(31.0, 78.0 - rfHeight, 6.0, rfHeight).offset(this.mainGui.rootElement));
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.field_146296_j.func_180450_b(new ItemStack((Item)BCCoreItems.gearIron), x + 78, y + 22);
        this.field_146296_j.func_180450_b(new ItemStack((Item)BCCoreItems.gearGold), x + 101, y + 22);
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.65f);
        ICON_OVERLAY.drawAt(this.mainGui.rootElement.offset(57.0, 18.0));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
    }

    @Override
    protected void drawForegroundLayer() {
        String str = LocaleUtil.localize("tile.engineRf.name");
        int strWidth = this.field_146289_q.func_78256_a(str);
        double titleX = this.mainGui.rootElement.getCenterX() - (double)(strWidth / 2);
        double titleY = this.mainGui.rootElement.getY() + 6.0;
        this.field_146289_q.func_78276_b(str, (int)titleX, (int)titleY, 0x404040);
        double invX = this.mainGui.rootElement.getX() + 8.0;
        double invY = this.mainGui.rootElement.getY() + 177.0 - 96.0;
        this.field_146289_q.func_78276_b(LocaleUtil.localize("gui.inventory"), (int)invX, (int)invY, 0x404040);
    }
}

