/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.transport.pipe;

import buildcraft.api.core.CapabilitiesHelper;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.transport.IInjectable;
import buildcraft.api.transport.IStripesRegistry;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeExtensionManager;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.IPipeRegistry;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.api.transport.pipe.PipeFlowType;
import buildcraft.api.transport.pluggable.IPluggableRegistry;
import buildcraft.api.transport.pluggable.PipePluggable;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.common.capabilities.Capability;

public final class PipeApi {
    public static IPipeRegistry pipeRegistry;
    public static IPluggableRegistry pluggableRegistry;
    public static IStripesRegistry stripeRegistry;
    public static IPipeExtensionManager extensionManager;
    public static PipeFlowType flowStructure;
    public static PipeFlowType flowItems;
    public static PipeFlowType flowFluids;
    public static PipeFlowType flowPower;
    public static PipeFlowType flowRf;
    public static FluidTransferInfo fluidInfoDefault;
    public static PowerTransferInfo powerInfoDefault;
    public static RedstoneFluxTransferInfo rfInfoDefault;
    public static final Map<PipeDefinition, FluidTransferInfo> fluidTransferData;
    public static final Map<PipeDefinition, PowerTransferInfo> powerTransferData;
    public static final Map<PipeDefinition, RedstoneFluxTransferInfo> rfTransferData;
    @Nonnull
    public static final Capability<IPipeHolder> CAP_PIPE_HOLDER;
    @Nonnull
    public static final Capability<IPipe> CAP_PIPE;
    @Nonnull
    public static final Capability<PipePluggable> CAP_PLUG;
    @Nonnull
    public static final Capability<IInjectable> CAP_INJECTABLE;

    public static FluidTransferInfo getFluidTransferInfo(PipeDefinition def) {
        FluidTransferInfo info = fluidTransferData.get(def);
        if (info == null) {
            return fluidInfoDefault;
        }
        return info;
    }

    public static PowerTransferInfo getPowerTransferInfo(PipeDefinition def) {
        PowerTransferInfo info = powerTransferData.get(def);
        if (info == null) {
            return powerInfoDefault;
        }
        return info;
    }

    public static RedstoneFluxTransferInfo getRfTransferInfo(PipeDefinition def) {
        RedstoneFluxTransferInfo info = rfTransferData.get(def);
        if (info == null) {
            return rfInfoDefault;
        }
        return info;
    }

    static {
        fluidInfoDefault = new FluidTransferInfo(20, 10);
        powerInfoDefault = PowerTransferInfo.createFromResistance(8L * MjAPI.MJ, MjAPI.MJ / 32L, false);
        rfInfoDefault = new RedstoneFluxTransferInfo(80, false);
        fluidTransferData = new IdentityHashMap<PipeDefinition, FluidTransferInfo>();
        powerTransferData = new IdentityHashMap<PipeDefinition, PowerTransferInfo>();
        rfTransferData = new IdentityHashMap<PipeDefinition, RedstoneFluxTransferInfo>();
        CAP_PIPE = CapabilitiesHelper.registerCapability(IPipe.class);
        CAP_PLUG = CapabilitiesHelper.registerCapability(PipePluggable.class);
        CAP_PIPE_HOLDER = CapabilitiesHelper.registerCapability(IPipeHolder.class);
        CAP_INJECTABLE = CapabilitiesHelper.registerCapability(IInjectable.class);
    }

    public static class RedstoneFluxTransferInfo {
        public final int transferPerTick;
        public final boolean isReceiver;

        public RedstoneFluxTransferInfo(int transferPerTick, boolean isReceiver) {
            this.transferPerTick = transferPerTick;
            this.isReceiver = isReceiver;
        }
    }

    public static class PowerTransferInfo {
        public final long transferPerTick;
        public final long lossPerTick;
        public final long resistancePerTick;
        public final boolean isReceiver;

        public static PowerTransferInfo createFromLoss(long transferPerTick, long lossPerTick, boolean isReceiver) {
            return new PowerTransferInfo(transferPerTick, lossPerTick, lossPerTick * MjAPI.MJ / transferPerTick, isReceiver);
        }

        public static PowerTransferInfo createFromResistance(long transferPerTick, long resistancePerTick, boolean isReceiver) {
            return new PowerTransferInfo(transferPerTick, resistancePerTick, resistancePerTick * transferPerTick / MjAPI.MJ, isReceiver);
        }

        public PowerTransferInfo(long transferPerTick, long lossPerTick, long resistancePerTick, boolean isReceiver) {
            if (transferPerTick < 10L) {
                transferPerTick = 10L;
            }
            this.transferPerTick = transferPerTick;
            this.lossPerTick = lossPerTick;
            this.resistancePerTick = resistancePerTick;
            this.isReceiver = isReceiver;
        }
    }

    public static class FluidTransferInfo {
        public final int transferPerTick;
        public final double transferDelayMultiplier;

        public FluidTransferInfo(int transferPerTick, int transferDelay) {
            this.transferPerTick = transferPerTick;
            if (transferDelay <= 0) {
                transferDelay = 1;
            }
            this.transferDelayMultiplier = transferDelay;
        }
    }
}

