/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.configuration;

import doggytalents.lib.ConfigValues;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    public static Configuration CONFIG;
    public static final String CATEGORY_DOGGYSETTINGS = "doggySettings";
    public static final String CATEGORY_TALENT = "talents";
    public static final String CATEGORY_GENERAL = "general";

    public static void init(Configuration configuration) {
        CONFIG = configuration;
        ConfigurationHandler.loadConfig();
    }

    public static void loadConfig() {
        String[] talentIds;
        CONFIG.addCustomCategoryComment(CATEGORY_GENERAL, "General settings for the mod");
        CONFIG.addCustomCategoryComment(CATEGORY_DOGGYSETTINGS, "Change certain behaviors of dogs");
        CONFIG.addCustomCategoryComment(CATEGORY_TALENT, "Enable and disable talents here as you wish");
        ArrayList<String> orderDTGeneral = new ArrayList<String>();
        ConfigValues.DEBUG_MODE = CONFIG.get(CATEGORY_GENERAL, "debugMode", false, "Enables debugging mode, which would output values for the sake of finding issues in the mod.").setRequiresMcRestart(false).setRequiresWorldRestart(false).getBoolean(false);
        orderDTGeneral.add("debugMode");
        CONFIG.setCategoryPropertyOrder(CATEGORY_GENERAL, orderDTGeneral);
        ArrayList<String> orderDSetting = new ArrayList<String>();
        ConfigValues.DOGS_IMMORTAL = CONFIG.get(CATEGORY_DOGGYSETTINGS, "isDogImmortal", true, "Determines if dogs die when their health reaches zero. If true, dogs will not die, and will instead become incapacitated.").setRequiresMcRestart(true).getBoolean(true);
        ConfigValues.TIME_TO_MATURE = CONFIG.getInt(CATEGORY_DOGGYSETTINGS, "timeToMature", 48000, 0, Integer.MAX_VALUE, "The time in ticks it takes for a baby dog to become an adult, default 48000 (2 Minecraft days) and minimum 0");
        ConfigValues.IS_HUNGER_ON = CONFIG.get(CATEGORY_DOGGYSETTINGS, "isHungerOn", true, "Enables hunger mode for the dog").getBoolean(true);
        ConfigValues.DIRE_PARTICLES = CONFIG.get(CATEGORY_DOGGYSETTINGS, "direParticles", true, "Enables the particle effect on Dire Level 30 dogs.").getBoolean(true);
        ConfigValues.STARTING_ITEMS = CONFIG.get(CATEGORY_DOGGYSETTINGS, "isStartingItemsEnabled", false, "When enabled you will spawn with a guide, Doggy Charm and Command Emblem.").getBoolean(false);
        ConfigValues.DOG_GENDER = CONFIG.get(CATEGORY_DOGGYSETTINGS, "dogGender", true, "When enabled, dogs will be randomly assigned genders and will only mate and produce children with the opposite gender").setRequiresMcRestart(true).getBoolean(false);
        ConfigValues.DOG_WHINE_WHEN_HUNGER_LOW = CONFIG.get(CATEGORY_DOGGYSETTINGS, "shouldWhineWhenStarving", true, "Determines if dogs should whine when hunger reaches below 20 DP").getBoolean(true);
        ConfigValues.USE_DT_TEXTURES = CONFIG.get(CATEGORY_DOGGYSETTINGS, "useDTTextures", true, "If disabled will use the default minecraft wolf skin for all dog textures.").getBoolean(true);
        ConfigValues.RENDER_CHEST = CONFIG.get(CATEGORY_DOGGYSETTINGS, "doggyChest", true, "When enabled, dogs with points in pack puppy will have chests on their side.").getBoolean(true);
        ConfigValues.RENDER_SADDLE = CONFIG.get(CATEGORY_DOGGYSETTINGS, "doggySaddle", true, "When enabled, dogs with points in wolf mount will have a saddle on.").getBoolean(true);
        ConfigValues.RENDER_BLOOD = CONFIG.get(CATEGORY_DOGGYSETTINGS, "bloodWhenIncapacitated", true, "When enabled, Dogs will show blood texture while incapacitated.").getBoolean(true);
        ConfigValues.RENDER_WINGS = CONFIG.get(CATEGORY_DOGGYSETTINGS, "doggyWings", false, "When enabled, Dogs will have wings when at level 5 pillow paw").getBoolean(false);
        ConfigValues.RENDER_ARMOUR = CONFIG.get(CATEGORY_DOGGYSETTINGS, "doggyArmour", false, "When enabled, dogs with points in guard dog will have armour.").getBoolean(false);
        ConfigValues.MOD_BED_STUFF = CONFIG.get(CATEGORY_DOGGYSETTINGS, "modBedStuff", true, "When enabled, some mods that add new planks will be able to be used for dog beds.").getBoolean(true);
        ConfigValues.PUPS_GET_PARENT_LEVELS = CONFIG.get(CATEGORY_DOGGYSETTINGS, "pupsGetParentLevel", false, "When enabled, puppies get some levels from parents. When disabled, puppies start at 0 points").getBoolean(false);
        orderDSetting.add("isDogImmortal");
        orderDSetting.add("tenDayPuppies");
        orderDSetting.add("isHungerOn");
        orderDSetting.add("dogGender");
        orderDSetting.add("shouldWhineWhenStarving");
        orderDSetting.add("pupsGetParentLevel");
        orderDSetting.add("isStartingItemsEnabled");
        orderDSetting.add("modBedStuff");
        orderDSetting.add("direParticles");
        orderDSetting.add("bloodWhenIncapacitated");
        orderDSetting.add("doggyChest");
        orderDSetting.add("doggySaddle");
        orderDSetting.add("doggyWings");
        orderDSetting.add("doggyArmour");
        orderDSetting.add("dogGender");
        CONFIG.setCategoryPropertyOrder(CATEGORY_DOGGYSETTINGS, orderDSetting);
        ConfigValues.DISABLED_TALENTS.clear();
        for (String talentId : talentIds = new String[]{"doggytalents:bed_finder", "doggytalents:black_pelt", "doggytalents:creeper_sweeper", "doggytalents:doggy_dash", "doggytalents:fisher_dog", "doggytalents:guard_dog", "doggytalents:happy_eater", "doggytalents:hell_hound", "doggytalents:hunter_dog", "doggytalents:pack_puppy", "doggytalents:pest_fighter", "doggytalents:pillow_paw", "doggytalents:poison_fang", "doggytalents:puppy_eyes", "doggytalents:quick_healer", "doggytalents:rescue_dog", "doggytalents:roaring_gale", "doggytalents:shepherd_dog", "doggytalents:swimmer_dog", "doggytalents:wolf_mount"}) {
            boolean enabled = CONFIG.get(CATEGORY_TALENT, talentId, true).getBoolean(true);
            if (enabled) continue;
            ConfigValues.DISABLED_TALENTS.add(talentId);
        }
        if (CONFIG.hasChanged()) {
            CONFIG.save();
        }
    }
}

