/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemList {
    public static final Logger LOGGER = LogManager.getLogger((String)"Doggy Talents");
    private List<List<Object>> itemlist = new ArrayList<List<Object>>();

    public void registerItem(Item ... items) {
        for (Item item : items) {
            this.registerItem(item);
        }
    }

    public void registerItem(Item item) {
        this.registerItem(item, Short.MAX_VALUE);
    }

    public void registerItem(Item item, int meta) {
        List<Object> array = Arrays.asList(item, meta);
        if (this.itemlist.contains(array)) {
            LOGGER.warn("The item {} meta {} is already registered in this item list", (Object)item.getRegistryName(), (Object)meta);
        } else {
            this.itemlist.add(array);
            LOGGER.debug("The item {} meta {} was register to an item list", (Object)item.getRegistryName(), (Object)meta);
        }
    }

    public boolean containsItem(Item item) {
        return this.containsItem(item, Short.MAX_VALUE);
    }

    public boolean containsItem(ItemStack stack) {
        return this.containsItem(stack.func_77973_b(), stack.func_77952_i());
    }

    public boolean containsItem(Item item, int meta) {
        List<Object> array = Arrays.asList(item, meta);
        List<Object> array_any = Arrays.asList(item, Short.MAX_VALUE);
        return this.itemlist.contains(array) || this.itemlist.contains(array_any);
    }
}

