/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.items.tools;

import codechicken.lib.util.ItemNBTUtils;
import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.registry.Feature;
import com.brandon3055.draconicevolution.api.itemconfig.BooleanConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.DoubleConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IntegerConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.client.model.tool.ToolOverrideList;
import com.brandon3055.draconicevolution.client.model.tool.ToolTransforms;
import com.brandon3055.draconicevolution.items.tools.DraconicBow;
import java.util.List;
import javax.annotation.Nullable;
import net.foxmcloud.draconicadditions.items.IChaosItem;
import net.foxmcloud.draconicadditions.items.tools.ToolStats;
import net.foxmcloud.draconicadditions.utils.DATextures;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChaoticBow
extends DraconicBow
implements IChaosItem {
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        super.func_150895_a(tab, subItems);
        if (this.func_194125_a(tab)) {
            ItemStack uberStack = (ItemStack)subItems.remove(subItems.size() - 1);
            this.setChaosStable(uberStack, true);
            subItems.add((Object)uberStack);
        }
    }

    public ItemConfigFieldRegistry getFields(ItemStack stack, ItemConfigFieldRegistry registry) {
        double maxDamage = com.brandon3055.draconicevolution.items.tools.ToolStats.BOW_BASE_DAMAGE + this.getToolTier(stack) * com.brandon3055.draconicevolution.items.tools.ToolStats.BOW_TIER_MULT_DAMAGE + UpgradeHelper.getUpgradeLevel((ItemStack)stack, (String)"arrowDmg") * com.brandon3055.draconicevolution.items.tools.ToolStats.BOW_MULT_DAMAGE;
        int maxSpeed = com.brandon3055.draconicevolution.items.tools.ToolStats.BOW_BASE_SPEED + this.getToolTier(stack) * com.brandon3055.draconicevolution.items.tools.ToolStats.BOW_TIER_MULT_SPEED + UpgradeHelper.getUpgradeLevel((ItemStack)stack, (String)"arrowSpeed") * com.brandon3055.draconicevolution.items.tools.ToolStats.BOW_MULT_SPEED;
        registry.register(stack, (IItemConfigField)new DoubleConfigField("bowArrowDamage", maxDamage, 0.0, maxDamage, "config.field.bowArrowDamage.description", IItemConfigField.EnumControlType.SLIDER));
        registry.register(stack, (IItemConfigField)new IntegerConfigField("bowArrowSpeedModifier", maxSpeed, 0, maxSpeed, "config.field.bowArrowSpeedModifier.description", IItemConfigField.EnumControlType.SLIDER).setPrefix("+").setExtension("%"));
        registry.register(stack, (IItemConfigField)new BooleanConfigField("bowAutoFire", Boolean.valueOf(false), "config.field.bowAutoFire.description"));
        registry.register(stack, (IItemConfigField)new IntegerConfigField("bowZoomModifier", 0, 0, this.getMaxZoomModifier(stack), "config.field.bowZoomModifier.description", IItemConfigField.EnumControlType.SLIDER));
        registry.register(stack, (IItemConfigField)new DoubleConfigField("bowShockPower", 0.0, 0.0, 5.0, "config.field.bowShockPower.description", IItemConfigField.EnumControlType.SLIDER));
        registry.register(stack, (IItemConfigField)new BooleanConfigField("bowFireArrow", Boolean.valueOf(true), "config.field.bowFireArrow.description.disabled"));
        return registry;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.func_72820_D() % 20L == 0L) {
            if (!this.isChaosStable(stack)) {
                double maxDamage = com.brandon3055.draconicevolution.items.tools.ToolStats.BOW_BASE_DAMAGE + this.getToolTier(stack) * com.brandon3055.draconicevolution.items.tools.ToolStats.BOW_TIER_MULT_DAMAGE + UpgradeHelper.getUpgradeLevel((ItemStack)stack, (String)"arrowDmg") * com.brandon3055.draconicevolution.items.tools.ToolStats.BOW_MULT_DAMAGE;
                int maxSpeed = com.brandon3055.draconicevolution.items.tools.ToolStats.BOW_BASE_SPEED + this.getToolTier(stack) * com.brandon3055.draconicevolution.items.tools.ToolStats.BOW_TIER_MULT_SPEED + UpgradeHelper.getUpgradeLevel((ItemStack)stack, (String)"arrowSpeed") * com.brandon3055.draconicevolution.items.tools.ToolStats.BOW_MULT_SPEED;
                ToolConfigHelper.setDoubleField((String)"bowArrowDamage", (ItemStack)stack, (double)maxDamage);
                ToolConfigHelper.setIntegerField((String)"bowArrowSpeedModifier", (ItemStack)stack, (int)maxSpeed);
                ToolConfigHelper.setDoubleField((String)"bowShockPower", (ItemStack)stack, (double)1.0);
                ToolConfigHelper.setBooleanField((String)"bowAutoFire", (ItemStack)stack, (boolean)true);
            }
            ToolConfigHelper.setBooleanField((String)"bowFireArrow", (ItemStack)stack, (boolean)true);
        }
    }

    public int getProfileCount(ItemStack stack) {
        return this.isChaosStable(stack) ? 5 : 1;
    }

    public void loadEnergyStats() {
        int capacity = ToolStats.CHAOTIC_BASE_CAPACITY;
        this.setEnergyStats(capacity, capacity, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (this.getChaosInfoStable(stack) != null) {
            tooltip.add(this.getChaosInfoStable(stack));
        }
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return 4;
    }

    public int getToolTier(ItemStack stack) {
        return 3;
    }

    public int getReaperLevel(ItemStack stack) {
        return 3;
    }

    public void registerRenderer(Feature feature) {
        super.registerRenderer(feature);
        ToolOverrideList.putOverride((Item)this, ChaoticBow::handleTransforms);
    }

    @SideOnly(value=Side.CLIENT)
    private static IModelState handleTransforms(ItemCameraTransforms.TransformType transformType, IModelState state) {
        return transformType == ItemCameraTransforms.TransformType.FIXED || transformType == ItemCameraTransforms.TransformType.GROUND ? ToolTransforms.STAFF_STATE : state;
    }

    public PairKV<TextureAtlasSprite, ResourceLocation> getModels(ItemStack stack) {
        byte pull = ItemNBTUtils.getByte((ItemStack)stack, (String)"render:bow_pull");
        return new PairKV((Object)DATextures.CHAOTIC_BOW[pull], (Object)new ResourceLocation("draconicadditions", String.format("models/item/tools/chaotic_bow0%s.obj", pull)));
    }
}

