/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.items.tools;

import com.brandon3055.brandonscore.items.ItemEnergyBase;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.api.IInvCharge;
import com.brandon3055.draconicevolution.api.itemupgrade.IUpgradableItem;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.foxmcloud.draconicadditions.CommonMethods;
import net.foxmcloud.draconicadditions.DAFeatures;
import net.foxmcloud.draconicadditions.blocks.tileentity.TileChaosHolderBase;
import net.foxmcloud.draconicadditions.capabilities.ChaosInBloodProvider;
import net.foxmcloud.draconicadditions.capabilities.IChaosInBlood;
import net.foxmcloud.draconicadditions.items.IChaosContainer;
import net.foxmcloud.draconicadditions.items.tools.ToolStats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChaosContainer
extends ItemEnergyBase
implements IChaosContainer,
IUpgradableItem,
IInvCharge {
    public ChaosContainer() {
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            ItemStack stack = new ItemStack((Item)this);
            this.setEnergy(stack, this.getCapacity(stack));
            this.addChaos(stack, this.getMaxChaos(stack));
            subItems.add((Object)stack);
        }
    }

    @Override
    public int getMaxChaos(ItemStack stack) {
        int upgrade = UpgradeHelper.getUpgradeLevel((ItemStack)stack, (String)"shieldCap");
        return ToolStats.CHAOS_CONTAINER_MAX_CHAOS * (upgrade + 1);
    }

    public int getCapacity(ItemStack stack) {
        int upgrade = UpgradeHelper.getUpgradeLevel((ItemStack)stack, (String)"rfCap");
        return ToolStats.CHAOS_CONTAINER_MAX_RF * (upgrade + 1);
    }

    public int getMaxReceive(ItemStack stack) {
        int upgrade = UpgradeHelper.getUpgradeLevel((ItemStack)stack, (String)"rfCap");
        return ToolStats.CHAOS_CONTAINER_MAX_TRANSFER * (upgrade + 1);
    }

    public int getMaxExtract(ItemStack stack) {
        return this.getMaxChaos(stack) * ToolStats.CHAOS_CONTAINER_RF_PER_CHAOS * 2;
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.getChaos(stack) > 0;
    }

    public List<String> getValidUpgrades(ItemStack stack) {
        return new ArrayList<String>(){
            {
                this.add("rfCap");
                this.add("shieldCap");
            }
        };
    }

    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return 3;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!(entity instanceof EntityPlayer) || world.field_72995_K) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        this.upkeep(player, stack, world);
    }

    public void upkeep(EntityPlayer player, ItemStack stack, World world) {
        if (this.func_77636_d(stack) && !player.func_184812_l_()) {
            int drainedRF;
            if (CommonMethods.cheatCheck(stack, world)) {
                ItemNBTHelper.setInteger((ItemStack)stack, (String)"Energy", (int)0);
            }
            if ((drainedRF = this.extractEnergy(stack, this.getChaos(stack) * ToolStats.CHAOS_CONTAINER_RF_PER_CHAOS, false)) != this.getChaos(stack) * ToolStats.CHAOS_CONTAINER_RF_PER_CHAOS) {
                Vec3D pos = new Vec3D(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                CommonMethods.explodeEntity(pos, world);
                player.func_70097_a(CommonMethods.chaosBurst, (float)this.getChaos(stack));
                player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.da.chaosContainer.explode", new Object[0]), true);
                stack.func_190918_g(1);
            }
        } else {
            CommonMethods.cheatCheck(stack, world);
        }
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        if (this.getChaos(stack) > 0 && !player.func_184812_l_()) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.da.chaosContainer.cantdrop", new Object[0]), true);
            return false;
        }
        ItemNBTHelper.setLong((ItemStack)stack, (String)"cheatCheck", (long)0L);
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityLiving) {
            EntityLiving ent = (EntityLiving)entity;
            if (this.getChaos(stack) > 0 && !ent.func_180431_b(CommonMethods.chaosBurst)) {
                Vec3D pos = new Vec3D(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
                CommonMethods.explodeEntity(pos, player.field_70170_p);
                if (!player.field_70170_p.field_72995_K) {
                    float damage = Math.min((float)this.getChaos(stack), ent.func_110143_aJ());
                    entity.func_70097_a(CommonMethods.chaosBurst, damage);
                    this.removeChaos(stack, (int)Math.floor(damage));
                }
                return true;
            }
        }
        return false;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.func_175625_s(pos) instanceof TileChaosHolderBase) {
            TileChaosHolderBase tileEntity = (TileChaosHolderBase)world.func_175625_s(pos);
            if (((ChaosContainer)stack.func_77973_b()).getChaos(stack) > 0 && tileEntity.chaos.value != tileEntity.getMaxChaos()) {
                int chaosToRemove = Math.min(this.getMaxChaos(stack) - tileEntity.chaos.value, this.getChaos(stack));
                this.removeChaos(stack, chaosToRemove);
                tileEntity.chaos.value += chaosToRemove;
            } else {
                int chaosToAdd = Math.min(this.getMaxChaos(stack) - this.getChaos(stack), tileEntity.chaos.value);
                this.addChaos(stack, chaosToAdd);
                tileEntity.chaos.value -= chaosToAdd;
            }
            return EnumActionResult.SUCCESS;
        }
        IChaosInBlood pCap = (IChaosInBlood)player.getCapability(ChaosInBloodProvider.PLAYER_CAP, null);
        if (pCap != null && player.func_70089_S() && pCap.getChaos() > 0.0f) {
            ActionResult<ItemStack> result = this.func_77659_a(world, player, hand);
            stack = (ItemStack)result.func_188398_b();
            return result.func_188397_a();
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IChaosInBlood pCap = (IChaosInBlood)player.getCapability(ChaosInBloodProvider.PLAYER_CAP, null);
        if (pCap != null && player.func_70089_S() && pCap.getChaos() > 0.0f) {
            int chaosToAdd = (int)(Math.min(pCap.getChaos(), 2.0f) * 4.0f);
            this.addChaos(stack, chaosToAdd);
            pCap.removeChaos((float)chaosToAdd / 4.0f);
            if ((double)pCap.getChaos() <= 0.25) {
                ItemStack chest = player.field_71071_by.func_70440_f(2);
                if (chest.func_77973_b() == DAFeatures.chaoticChest && ItemNBTHelper.getBoolean((ItemStack)chest, (String)"injecting", (boolean)false)) {
                    ItemNBTHelper.setBoolean((ItemStack)chest, (String)"injecting", (boolean)false);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.da.chaosInjection.failsafe", new Object[0]), true);
                }
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.da.chaosContainer.charge", new Object[0]), true);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(this.getChaosInfo(stack));
        if (this.getMaxEnergyStored(stack) > 0) {
            tooltip.add(I18n.func_135052_a((String)"info.da.shieldcharge.txt", (Object[])new Object[0]) + ": " + this.getEnergyStored(stack) + " / " + this.getMaxEnergyStored(stack) + " RF");
        }
    }

    public boolean canCharge(ItemStack stack, EntityPlayer player) {
        return true;
    }
}

