/*
 * Decompiled with CFR 0.152.
 */
package net.foxmcloud.draconicadditions.blocks.tileentity;

import cofh.redstoneflux.api.IEnergyReceiver;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import net.foxmcloud.draconicadditions.blocks.tileentity.TileChaosHolderBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;

public class TileChaosLiquefier
extends TileChaosHolderBase
implements IEnergyReceiver,
ITickable,
IChangeListener {
    private int chargeRate = 10000000;
    public int maxCharge = 200;
    public final ManagedInt charge = (ManagedInt)this.register("charge", (IManagedData)new ManagedInt(0)).saveToTile().saveToItem().syncViaTile().trigerUpdate().finish();
    public final ManagedInt chargeTo = (ManagedInt)this.register("chargeTo", (IManagedData)new ManagedInt(this.maxCharge)).saveToTile().saveToItem().syncViaTile().trigerUpdate().finish();
    public final ManagedBool active = (ManagedBool)this.register("active", (IManagedData)new ManagedBool(false)).saveToTile().saveToItem().syncViaTile().trigerUpdate().finish();
    public final ManagedBool powered = (ManagedBool)this.register("powered", (IManagedData)new ManagedBool(false)).saveToTile().saveToItem().syncViaTile().trigerUpdate().finish();

    public TileChaosLiquefier() {
        this.setInventorySize(1);
        this.setEnergySyncMode().syncViaContainer();
        this.setCapacityAndTransfer(2000000000, 20000000, 20000000);
        this.setShouldRefreshOnBlockChange();
    }

    public void func_73660_a() {
        super.update();
        if (this.field_145850_b.field_72995_K) {
            if (this.active.value) {
                if (this.charge.value >= 0 && this.charge.value < this.chargeTo.value - 1) {
                    float beamPitch = 1.5f * (float)this.charge.value / (float)this.maxCharge + 0.5f;
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, DESoundHandler.beam, SoundCategory.BLOCKS, 0.2f, beamPitch, false);
                } else {
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, DESoundHandler.boom, SoundCategory.BLOCKS, 1.0f, 2.0f, false);
                }
            }
        } else {
            this.active.value = this.charge.value > 0;
            ItemStack stack = this.func_70301_a(0);
            if (!stack.func_190926_b() && this.func_94041_b(0, stack) && this.chaos.value < this.getMaxChaos()) {
                int finalCharge = this.calcCharge(stack);
                if (finalCharge != this.chargeTo.value) {
                    this.chargeTo.value = finalCharge;
                }
                if (this.energyStorage.getEnergyStored() >= this.chargeRate) {
                    ++this.charge.value;
                    this.energyStorage.modifyEnergyStored(-this.chargeRate);
                    if (this.charge.value >= this.chargeTo.value) {
                        this.discharge();
                    }
                } else if (this.charge.value > 0) {
                    --this.charge.value;
                }
            } else if (this.charge.value > 0) {
                --this.charge.value;
            }
        }
    }

    public void discharge() {
        ItemStack stack = this.func_70301_a(0);
        this.chaos.value += this.calcChaos(stack);
        if (this.chaos.value > this.getMaxChaos()) {
            this.chaos.value = this.getMaxChaos();
        }
        stack.func_190918_g(1);
        if (stack.func_190916_E() == 0) {
            stack = ItemStack.field_190927_a;
        }
        this.charge.value = 0;
    }

    public int calcChaos(ItemStack stack) {
        if (this.func_94041_b(0, stack)) {
            switch (stack.func_77973_b().getMetadata(stack)) {
                case 0: {
                    return 1300;
                }
                case 1: {
                    return 150;
                }
                case 2: {
                    return 17;
                }
                case 3: {
                    return 2;
                }
            }
            return 0;
        }
        return 0;
    }

    public int calcCharge(ItemStack stack) {
        if (this.func_94041_b(0, stack)) {
            switch (stack.func_77973_b().getMetadata(stack)) {
                case 0: {
                    return this.maxCharge;
                }
                case 1: {
                    return this.maxCharge / 2;
                }
                case 2: {
                    return this.maxCharge / 4;
                }
                case 3: {
                    return this.maxCharge / 8;
                }
            }
            return this.maxCharge;
        }
        return 0;
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (stack.func_77973_b() == Item.func_111206_d((String)"draconicevolution:chaos_shard")) {
            return true;
        }
        return stack.func_77973_b() == Item.func_111206_d((String)"draconicadditions:chaos_heart");
    }

    public void onNeighborChange(BlockPos neighbor) {
        this.powered.value = this.field_145850_b.func_175640_z(this.field_174879_c);
    }
}

